/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.pathfinding;

import com.minecolonies.api.util.WorldUtil;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.lighting.WorldLightManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class ChunkCache
implements IWorldReader {
    protected int chunkX;
    protected int chunkZ;
    protected Chunk[][] chunkArray;
    protected boolean empty;
    protected World world;

    public ChunkCache(World worldIn, BlockPos posFromIn, BlockPos posToIn, int subIn) {
        this.world = worldIn;
        this.chunkX = posFromIn.func_177958_n() - subIn >> 4;
        this.chunkZ = posFromIn.func_177952_p() - subIn >> 4;
        int i = posToIn.func_177958_n() + subIn >> 4;
        int j = posToIn.func_177952_p() + subIn >> 4;
        this.chunkArray = new Chunk[i - this.chunkX + 1][j - this.chunkZ + 1];
        this.empty = true;
        for (int k = this.chunkX; k <= i; ++k) {
            for (int l = this.chunkZ; l <= j; ++l) {
                if (!WorldUtil.isEntityChunkLoaded((IWorld)this.world, new ChunkPos(k, l))) continue;
                this.chunkArray[k - this.chunkX][l - this.chunkZ] = (Chunk)worldIn.func_217353_a(k, l, ChunkStatus.field_222617_m, false);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isEmpty() {
        return this.empty;
    }

    @Nullable
    public TileEntity func_175625_s(@NotNull BlockPos pos) {
        return this.getTileEntity(pos, Chunk.CreateEntityType.CHECK);
    }

    @Nullable
    public TileEntity getTileEntity(BlockPos pos, Chunk.CreateEntityType createType) {
        int j;
        int i = (pos.func_177958_n() >> 4) - this.chunkX;
        if (!this.withinBounds(i, j = (pos.func_177952_p() >> 4) - this.chunkZ)) {
            return null;
        }
        return this.chunkArray[i][j].func_177424_a(pos, createType);
    }

    @NotNull
    public BlockState func_180495_p(BlockPos pos) {
        if (pos.func_177956_o() >= 0 && pos.func_177956_o() < 256) {
            Chunk chunk;
            int i = (pos.func_177958_n() >> 4) - this.chunkX;
            int j = (pos.func_177952_p() >> 4) - this.chunkZ;
            if (i >= 0 && i < this.chunkArray.length && j >= 0 && j < this.chunkArray[i].length && (chunk = this.chunkArray[i][j]) != null) {
                return chunk.func_180495_p(pos);
            }
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    public FluidState func_204610_c(BlockPos pos) {
        if (pos.func_177956_o() >= 0 && pos.func_177956_o() < 256) {
            Chunk chunk;
            int i = (pos.func_177958_n() >> 4) - this.chunkX;
            int j = (pos.func_177952_p() >> 4) - this.chunkZ;
            if (i >= 0 && i < this.chunkArray.length && j >= 0 && j < this.chunkArray[i].length && (chunk = this.chunkArray[i][j]) != null) {
                return chunk.func_204610_c(pos);
            }
        }
        return Fluids.field_204541_a.func_207188_f();
    }

    public Biome func_225604_a_(int x, int y, int z) {
        return null;
    }

    public boolean func_175623_d(BlockPos pos) {
        BlockState state = this.func_180495_p(pos);
        return state.func_177230_c().isAir(state, (IBlockReader)this, pos);
    }

    @Nullable
    public IChunk func_217353_a(int x, int z, ChunkStatus requiredStatus, boolean nonnull) {
        return null;
    }

    public boolean func_217354_b(int chunkX, int chunkZ) {
        return false;
    }

    public BlockPos func_205770_a(Heightmap.Type heightmapType, BlockPos pos) {
        return null;
    }

    public int func_201676_a(Heightmap.Type heightmapType, int x, int z) {
        return 0;
    }

    public int func_175657_ab() {
        return 0;
    }

    public BiomeManager func_225523_d_() {
        return null;
    }

    public WorldBorder func_175723_af() {
        return null;
    }

    public boolean func_195585_a(@Nullable Entity entityIn, VoxelShape shape) {
        return false;
    }

    public Stream<VoxelShape> func_230318_c_(@Nullable Entity entity, AxisAlignedBB axisAlignedBB, Predicate<Entity> predicate) {
        return null;
    }

    public int func_175627_a(BlockPos pos, Direction direction) {
        return this.func_180495_p(pos).func_185893_b((IBlockReader)this, pos, direction);
    }

    public boolean func_201670_d() {
        return false;
    }

    public int func_181545_F() {
        return 0;
    }

    public DimensionType func_230315_m_() {
        return null;
    }

    private boolean withinBounds(int x, int z) {
        return x >= 0 && x < this.chunkArray.length && z >= 0 && z < this.chunkArray[x].length && this.chunkArray[x][z] != null;
    }

    public float func_230487_a_(Direction direction, boolean b) {
        return 0.0f;
    }

    public WorldLightManager func_225524_e_() {
        return null;
    }
}

